/*!
 *******************************************************************************
 * \file             spi_tclMySPINSndCtrlMonitor.h
 * \brief            Implements udev monitor to retrieve changed sample rate of iAP device
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3 Projects
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    USB Audio Streaming Implementation for mySPIN
 COPYRIGHT:      &copy; BSOT

 HISTORY:
 Date       |  Author                          | Modifications
 03.09.2015 |  T.Quintern (BSOT/ENG - qto2hi)  | copy from spi_tclMySPINudevMonitor.h

 \endverbatim
 ******************************************************************************/

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#ifndef SPI_TCLMYSPINSNDCTRLMONITOR_H
#define SPI_TCLMYSPINSNDCTRLMONITOR_H

/******************************************************************************/
/* DEFINES                                                                     */
/******************************************************************************/
#define CTRL_UAC2_ELEM_P_RATE 0
#define CTRL_UAC2_ELEM_C_RATE 1
#define CTRL_UAC2_ELEM_P_ENABLED 2
#define CTRL_UAC2_ELEM_C_ENABLED 3
#define CTRL_UAC2_ELEMENTS 4

#include <alsa/asoundlib.h>
#include <stdint.h>

/******************************************************************************/
/* TYPES                                                                      */
/******************************************************************************/
struct uac2_ctrl {
    const char *name;
    snd_ctl_t *ctl;
    snd_ctl_elem_value_t *elems[CTRL_UAC2_ELEMENTS];
    unsigned long elems_val[CTRL_UAC2_ELEMENTS];
};

/******************************************************************************/
/* CLASSES                                                                    */
/******************************************************************************/
class spi_tclMySPINSndCtrlMonitorIF;

/***************************************************************************
** CLASS:  spi_tclMySPINSndCtrlMonitor::spi_tclMySPINSndCtrlMonitor()
***************************************************************************/
/*!
* \fn      spi_tclMySPINSndCtrlMonitor( )
* \brief   Implements snd_ctrl monitor to retrieve changed sample rate of iAP device.
*
**************************************************************************/
class spi_tclMySPINSndCtrlMonitor
{
public:

    spi_tclMySPINSndCtrlMonitor();
    virtual ~spi_tclMySPINSndCtrlMonitor();

    void vInitMonitor(spi_tclMySPINSndCtrlMonitorIF* ptrMonitorCallback);
    void vStopMonitor();

    bool bGetInitCaptureEnabled();

private:

    pthread_t _hMonitorThreadId;
    void vMonitorThreadSetup( );

    static void vMonitorThreadFunction( void* pvArg );

    void vSetMonitorCallback(spi_tclMySPINSndCtrlMonitorIF* ptrMonitorCallback);
    void vFireMonitorCallback(U32 u32SampleRate, bool bEndPointEnabled);

    // getter/setter
    //inline U32 u32GetSampleRate(){return(_u32SampleRate);}
    //inline void vSetSampleRate(U32 u32SampleRate){_u32SampleRate = u32SampleRate;}
    //inline bool bGetEndPointEnabled(){return(_bEndPointEnabled);}
    //inline void vSetSEndPointEnabled(bool bEndPointEnabled){_bEndPointEnabled = bEndPointEnabled;}


    // snd_ctl functions
    static S32 s32SndCtrlDeInit(struct uac2_ctrl *ctrl);
    static S32 s32SndCtrlInit(struct uac2_ctrl *ctrl);
    static void vElemFree(struct uac2_ctrl *ctrl, U32 u32Index );
    static S32 s32ElemInit(struct uac2_ctrl *ctrl, U32 u32Index, const char * name);
    static S32 s32ElemUpdate(struct uac2_ctrl *ctrl, U32 u32Index);
    static S32 s32ElemVal(struct uac2_ctrl *ctrl, U32 u32Index);


    bool _bTerminateMonitorThread;
    bool _bMonitorThreadCreated;
    U32  _u32SampleRate;         // sample rate fix for AOAP and BT audio; changes for iAP
    bool _bEndPointEnabled;      // 0/1 in case endpoint disabled/enabled.

    static bool bInitCaptureEnabled;
    static bool bInitDone;

    // callback IF
    spi_tclMySPINSndCtrlMonitorIF* _ptrMonitorCallback;

};

#endif // SPI_TCLMYSPINSNDCTRLMONITOR_H
